#ifndef SIMJOIN_H
#define SIMJOIN_H
#include "objectpair.h"
#include "preprocess.h"
#include <algorithm>
#include <vector>
#include <list>
#include <iostream>
#include <set>
using namespace std;

class Simjoin
{
public:

    Simjoin(vector <Object> s1, vector <Object> s2, int k);

    vector <Object> set1;   //set1.size >= set2.size
    vector <Object> set2;
    vector <ObjectPair> result_set;

    int k;
    int c_all, c_s, c_p, c_v;   //number of processed pairs, number of pairs left after size filtering,
                                //prefix filtering, verify
    int l_ob, l_pr;     //average length of object, prefix

    void join();
    void join(double time);

private:

    vector <pair<int, int> > SetOrder(); //return vector with order of pair processing
    //verify whether final score of pair big enough, return new threshold
    double Verify(Object& x, Object& y, int alpha, int sharedTokensCount);
    //count overlap threshold for a pair of objects
    int CountOverlapThreshold(double simThreshold, int size_x, int size_y);
    int countOverlap(vector<Token> object1, vector<Token> object2); //count overlap of two objects

    void saveStatistic();
    void initParam();   //initialize statistic parameters
    int countAllPairs(double time); //count amount of pairs algorithm can process in given time

};

#endif // SIMJOIN_H
